% This script plots loss of cells mass in CHX-treated G1 cells
load('Figure3A_Data.mat');
time=[0 1.5 3 6 9];

%% Figure 3A (G1)
temp20=[]; temp80=[];
% for kk=1:size(prct20,1) % no size normalization
%     temp20=[temp20,prct20{kk,1}-prct20{kk,1}(1,:)];
%     temp80=[temp80,prct80{kk,1}-prct80{kk,1}(1,:)];
% end
for kk=1:size(prct20,1) % normalize size by median
    temp20=[temp20, (prct20{kk}-prct20{kk}(1,:))./prct50{kk}(1,:)];
    temp80=[temp80, (prct80{kk}-prct80{kk}(1,:))./prct50{kk}(1,:)];
end
CI20=bsxfun(@times, nanstd(temp20,0,2)/sqrt(length(temp20)), tinv(0.975,length(temp20)-1));
CI80=bsxfun(@times, nanstd(temp80,0,2)/sqrt(length(temp80)), tinv(0.975,length(temp80)-1));

figure; hold on
Nn = size(temp20,2);
for tt = 1:length(time)
    scatter(time(tt)+randn(Nn,1)*0.1, temp20(tt,:), 6, [1 .6 0], 'filled','MarkerFaceAlpha',.5)
    scatter(time(tt)+randn(Nn,1)*0.1, temp80(tt,:), 6, [.5 .5 .5], 'filled','MarkerFaceAlpha',.5)
end

plot(time,nanmean(temp20,2),'o-','markerfacecolor',[1 .6 0],'color',[1 .6 0]); 
plot(time,nanmean(temp80,2),'o-','markerfacecolor',[0.5 0.5 0.5],'color',[0.5 0.5 0.5]);
errorbar(time,nanmean(temp20,2),CI20,'color',[1 .6 0],'linestyle','none');
errorbar(time,nanmean(temp80,2),CI80,'color',[0.5 0.5 0.5],'linestyle','none');
axis([-0.2 10 -0.5 0.01]); xlabel('Time (hr)'); ylabel('\DeltaCell Mass (a.u.)'); 
set(gca,'fontsize',15,'xtick',0:2:10,'ytick',-.5:.1:0); box off; title('G1')

